@echo off

rem *******************************************************************
rem * Ablauf:                                                         *
rem * - berprfen, ob RegFree.EXE vorhanden ist                      *
rem * - Nach Installations-Pfad von FST5 in der Registry suchen       *
rem * - Nach Installations-Pfad von CoDeSys in der Registry suchen    *
rem * - berprfen, ob InstallTarget.EXE vorhanden ist                *
rem * - berprfen, ob im aktuellen Ordner ein TNF-File vorhanden ist *
rem * - berprfen, ob DefaultInstallDir im TNF angegeben ist         *
rem * - berprfen, ob DefaultInstallDir einen relativen Pfad enthlt *
rem * - Target installieren                                           *
rem ****************************************************elpa,20050510**

echo.
echo TargetAutoInstaller, BECK IPC GmbH 2008 V1.2
echo ---------------------------------------------
echo.

set Force=
:: Check Commandline parameters
if     "X%1" == "X/?" goto Usage
if not "X%2" == "X"   goto Usage
if     "X%1" == "X/f" goto Set_Force
if     "X%1" == "X/F" goto Set_Force
goto start

:Usage
echo Installs a CoDeSys@CHIP TSP in the CoDeSys V2.3 Programmingsystem
echo.
echo Usage: INSTALL.BAT [option]
echo    Options:
echo       /?    Displays this Help info.
echo       /f    if an TSP is already installed with the same TargetID
echo             INSTALL.BAT will remove it (Use with care !!!).
echo.
echo Example: INSTALL.BAT /f
echo.
goto done_2

:Set_Force
:: Set the Force Flag parameter to "F"
set Force=F

:start
:: Check for REGfree.exe in current dir
if not exist "regfree.exe" goto ErrorReg

:: Check for 3S CoDeSys Install dir entry in Registry
set rp="\machine\software\3S-Smart Software Solutions GmbH\CoDeSys SetupInfo\V2.3.0\Targetdir_CODESYS"
for /f "tokens=1*" %%i in ('regfree -lv %rp%') do set RegValueType=%%i&set InstallDir=%%j
if %RegValueType% == Undefined goto ErrorNoSPS
set Type=CoDeSys
echo 1. Found CoDeSys Installation

:: Check for InstallTarget executable
if not exist "%InstallDir%\InstallTarget.exe" goto ErrorIT
echo 2. Found InstallTarget.EXE in %InstallDir%

:: Search for TNF file
for %%i in (*.tnf) do set TargetFile=%%i
if "%TargetFile%" == "" goto ErrorTNF
echo 3. Found installable Target   %TargetFile%

set IDir=
:: collect target id, vendor, product, and install_path
for /f "usebackqtokens=1,2,3* delims==," %%i in ("%TargetFile%") do (
  if "%%i" == "Target1"  set T_ID=%%k)
for /f "usebackqtokens=1* delims==" %%i in ("%TargetFile%") do (
  if "%%i" == "DefaultInstallDir" set IDir=%%j)
for /f "usebackqtokens=1,2,3* delims==\" %%i in ("%TargetFile%") do (
  if "%%i" == "DefaultInstallDir" set P_v=%%j&set P_p=%%k)
:: Check if InstallDir defined
if "X%IDir%" == "X" goto ErrorSub
:: Check if relative path is used in *.tnf file
if not "%IDir%" == "\%P_v%\%P_p%" goto ErrorRel


echo 4. Checking installed Targets:...
set ListFile=%temp%.\list.txt
:: Collect list of installed Targets from registry
type nul >%ListFile%
set rp=HKLM\software\AutomationAlliance\Targets
for /f "delims=\ tokens=5* " %%i in ('reg query "%rp%"') do (echo %%i>>%ListFile%)

:: Reset check parameter
set TRG_CHK=""
set TRG_Key=
set TRG_Nam=
:: Build bat file for checking each Registry entry
set ChkTrgFile=%temp%.\chktrg.bat
ECHO REM @echo off>%ChkTrgFile%
ECHO REM Generated Bat file>>%ChkTrgFile%
ECHO REM >>%ChkTrgFile%
REM use %ChkTrgFile% Item Key>>%ChkTrgFile%

REM echo echo "%%~1\%%~2\Id">>%ChkTrgFile%
ECHO for /f "tokens=1*" %%%%i in ('REGfree -lv "%%~1\%%~2\Id"')     do set Id_Val=%%%%j>>%ChkTrgFile%
ECHO for /f "tokens=1*" %%%%i in ('REGfree -lv "%%~1\%%~2\Name"')   do set Nam_Val=%%%%j>>%ChkTrgFile%
ECHO for /f "tokens=1*" %%%%i in ('REGfree -lv "%%~1\%%~2\Vendor"') do set Ven_Val=%%%%j>>%ChkTrgFile%

ECHO echo        Name=%%Nam_Val%%, Id=%%Id_Val%% ...>>%ChkTrgFile%
ECHO if "%%Id_Val%%"  == "%%T_Id%%" goto ERR_Id>>%ChkTrgFile%
ECHO if "%%Nam_Val%%" == "%%P_p%%"  goto ERR_Nam>>%ChkTrgFile%
ECHO goto End>>%ChkTrgFile%

ECHO :ERR_Id>>%ChkTrgFile%
ECHO if "%%Nam_Val%%" == "%%P_p%%"  goto ERR_Both>>%ChkTrgFile%

REM ECHO echo ERROR: Already a TSP with Id="%%T_Id%%" Installed>>%ChkTrgFile%
ECHO set TRG_CHK="Id">>%ChkTrgFile%
ECHO set TRG_Nam=\%%Nam_Val%%>>%ChkTrgFile%
ECHO set TRG_Key=\%%Ven_Val%%\%%Nam_Val%%>>%ChkTrgFile%
ECHO goto End>>%ChkTrgFile%

ECHO :Err_Nam>>%ChkTrgFile%
REM ECHO echo ERROR: Already a TSP with Name="%%P_p%%" Installed>>%ChkTrgFile%
ECHO set TRG_CHK="Name">>%ChkTrgFile%
ECHO set TRG_Nam=\%%Nam_Val%%>>%ChkTrgFile%
ECHO set TRG_Key=\%%Ven_Val%%\%%Nam_Val%%>>%ChkTrgFile%
ECHO goto End>>%ChkTrgFile%

ECHO :ERR_Both>>%ChkTrgFile%
REM ECHO echo ERROR: Already a TSP with Id="%%T_Id%%" and Name="%%P_p%%" Installed>>%ChkTrgFile%
ECHO set TRG_CHK="Both">>%ChkTrgFile%
ECHO set TRG_Nam=\%%Nam_Val%%>>%ChkTrgFile%
ECHO set TRG_Key=\%%Ven_Val%%\%%Nam_Val%%>>%ChkTrgFile%
ECHO goto End>>%ChkTrgFile%

ECHO :End>>%ChkTrgFile%
ECHO set Id_Val=>>%ChkTrgFile%
ECHO set Nam_Val=>>%ChkTrgFile%
ECHO set Ven_Val=>>%ChkTrgFile%
REM Echo Echo return>>%ChkTrgFile%
:: End of creating bat file

:: Check for all registry directory in ListFile
for /f "tokens=*" %%i in (%ListFile%) do (call %ChkTrgFile% "%rp%" "%%i")

:: Check result of scanning the registry
if %TRG_CHK% == "Both" goto ERR_BOTH
if %TRG_CHK% == "Id"   goto ERR_ID
if %TRG_CHK% == "Name" goto ERR_NAME
goto NO_ERR1

:ERR_BOTH
echo.
echo ERROR: Id="%T_Id%", Name="%P_p%" are already used by
echo           Target: "%TRG_Key%".
if "X%Force%" == "XF" goto Rem_ID
:: No Force set, ask interactive
:again
set UserAnsw=
set /P UserAnsw=Do you want to update/overwrite this existing TSP ? [y/n]
if     "X%UserAnsw%" == "Xy" goto Rem_ID
if not "X%UserAnsw%" == "Xn" goto again
:: answered negative, error
echo.         
echo        Use INSTALL.BAT /f to force Installation or 
goto ERR_Rest

goto again

:ERR_ID
echo.
echo ERROR: Id="%T_Id%" is already used by 
echo           Target: "%TRG_Key%".
if "X%Force%" == "XF" goto Rem_ID
:: No Force set, error
echo.        
echo        Use INSTALL.BAT /f to force Installation or 
goto ERR_Rest


:: Force flag active, remove target and do a second check
:Rem_ID
echo    Forced Remove installed Target :"%TRG_Key%" ...
REGfree -Q -DeleteTree "%rp%%TRG_Nam%"
rmdir /s /q "%InstallDir%\Targets\%TRG_Key%"

echo    Rechecking installed Targets:...
:: Recollect list of installed Targets from registry
type nul >%ListFile%
set rp=HKLM\software\AutomationAlliance\Targets
for /f "delims=\ tokens=5* " %%i in ('reg query "%rp%"') do (echo %%i>>%ListFile%)

:: Reset check parameter
set TRG_CHK=""
set TRG_Key=
set TRG_nam=
:: Check agin for all registry directory in ListFile
for /f "tokens=*" %%i in (%ListFile%) do (call %ChkTrgFile% "%rp%" "%%i")

:: Check result of scanning the registry
if %TRG_CHK% == "Both" goto ERR_BOTH
if %TRG_CHK% == "Id"   goto ERR_ID
if %TRG_CHK% == "Name" goto ERR_NAME
goto NO_ERR1

:ERR_NAME
echo.
echo ERROR: Name="%P_p%" is already used by
echo           Target: "%TRG_Key%".
echo.         
echo        Use another Target Name or 
goto ERR_Rest

:ERR_Rest
echo        1. Use 3S InstallTarget to remove Target:
echo              "%TRG_Key%".
echo        2. Delete the following Directory:
echo              "%InstallDir%\Targets%TRG_Key%"
echo           after removing this target.
echo.
echo        Aborting the Install script.
goto done

:NO_ERR1
:: Check if Target install directory does not exist or is empty
echo 5. Check Instalation directory ...
if exist "%InstallDir%\Targets" goto CHK_Dir
mkdir "%InstallDir%\Targets"
:CHK_Dir
if not exist "%InstallDir%\Targets\%P_v%" goto OK_Dir
if not exist "%InstallDir%\Targets\%P_v%\%P_p%" goto OK_Dir
set EMP=
DIR /B "%InstallDir%\Targets\%P_v%\%P_p%">%temp%.\dl.txt
for /f %%i in (%temp%.\dl.txt) do set EMP=No
if "X%EMP%" == "XNo" goto ERR_Dir2

:OK_Dir
REM Target install directory does not exist or is empty
:: Finally ready to do the real work
echo 6. Installing Target to
echo    "%InstallDir%\Targets\%P_v%\%P_p%"
"%InstallDir%\InstallTarget.exe" "%TargetFile%" /auto %InstallDir%\Targets
echo 7. Finished.

goto done

:ErrorReg
echo ERROR: REGFREE.EXE not found.
goto done

:ErrorNoSPS
echo ERROR: FST5 or CoDeSys not found.
goto done

:ErrorIT
echo.
echo ERROR: %InstallDir%\InstallTarget.EXE not found.
echo.
goto done

:ErrorTNF
echo.
echo ERROR: TNF-File not found.
echo.
goto done

:ErrorSub
echo.
echo ERROR: DefaultInstallDir= in %TargetFile% not found.
goto done

:ErrorRel
echo.
echo ERROR: DefaultInstallDir= in %TargetFile% does not contain a relative
echo        path starting with a backslash. You need to edit the Line
echo           "DefaultInstallDir=%IDir%"  into
echo           "DefaultInstallDir=\%P_v%\%P_p%".
echo.
echo        Aborting the Install script.
goto done

:ERR_Dir2
echo.
echo ERROR: Directory "%InstallDir%\Targets\%P_v%\%P_p%"
echo        does already exist and is not empty. After deinstalling
echo        a Target, the Directory must also be deleted.
echo.
echo        Aborting the Install script.
goto done


:done
if exist %ListFile%     del %ListFile%
if exist %ChkTrgFile%   del %ChkTrgFile%
if exist %temp%.\dl.txt del %temp%.\dl.txt
set Force=
set Type=
set rp=
set InstallDir=
set RegValueType=
set TargetFile=
set EMP=
set T_Id=
set P_v=
set P_p=
set IDir=
set TRG_CHK=
set TRG_Key=
set TRG_Nam=

:done_2
echo.
pause
